<?php
// حذف سيارة
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $car_id = $_GET['delete'];
    $conn->query("DELETE FROM cars WHERE id = $car_id");
    header("Location: ?page=cars&msg=deleted");
    exit();
}

// الحصول على جميع السيارات
$cars = $conn->query("SELECT * FROM cars ORDER BY created_at DESC");
?>

<?php if (isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
    <div class="success-message">تم حذف السيارة بنجاح</div>
<?php endif; ?>

<div style="margin-bottom: 20px;">
    <a href="?page=add-car" class="btn btn-primary">➕ إضافة سيارة جديدة</a>
</div>

<div class="table-container">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">قائمة السيارات</h2>
    <table>
        <thead>
            <tr>
                <th>الرقم</th>
                <th>الماركة</th>
                <th>الموديل</th>
                <th>السنة</th>
                <th>اللون</th>
                <th>السعر/اليوم</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($cars->num_rows > 0): ?>
                <?php while($car = $cars->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $car['id']; ?></td>
                        <td><?php echo htmlspecialchars($car['brand']); ?></td>
                        <td><?php echo htmlspecialchars($car['model']); ?></td>
                        <td><?php echo $car['year']; ?></td>
                        <td><?php echo htmlspecialchars($car['color']); ?></td>
                        <td><?php echo number_format($car['price_per_day'], 2); ?> ريال</td>
                        <td>
                            <?php 
                            $status_ar = [
                                'available' => '✅ متاحة',
                                'rented' => '🔑 مؤجرة',
                                'maintenance' => '🔧 صيانة'
                            ];
                            echo $status_ar[$car['status']];
                            ?>
                        </td>
                        <td>
                            <a href="?page=edit-car&id=<?php echo $car['id']; ?>" class="btn btn-success btn-small">تعديل</a>
                            <a href="?page=cars&delete=<?php echo $car['id']; ?>" 
                               onclick="return confirm('هل أنت متأكد من حذف هذه السيارة؟')" 
                               class="btn btn-danger btn-small">حذف</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" style="text-align: center;">لا توجد سيارات مسجلة</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>